% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{pivot_table}
\alias{pivot_table}
\title{\code{pivot_table} S3 class}
\usage{
pivot_table(
  df,
  page = "",
  page_row = 0,
  page_col = 0,
  n_col_labels = 0,
  n_row_labels = 0
)
}
\arguments{
\item{df}{A data frame, contains one or more pivot tables.}

\item{page}{A string, additional information associated with the pivot table.}

\item{page_row, page_col}{A cell (row and column number), page information
included in the table.}

\item{n_col_labels}{A number, number of columns containing pivot table labels.}

\item{n_row_labels}{A number, number of rows containing pivot table labels.}
}
\value{
A \code{pivot_table} object.
}
\description{
Creates a \code{pivot_table} object from a data frame. Additional information
associated with the pivot table can be indicated. The data frame data is
converted to character data type.
}
\examples{

pt <- pivot_table(df_ex)

pt <- pivot_table(df_ex, page = "M4")

pt <- pivot_table(df_ex, page_row = 1, page_col = 1)

pt <- pivot_table(df_ex, page_row = 1, page_col = 1, n_col_labels = 2, n_row_labels = 2)

}
\seealso{
\code{\link{divide}}

Other pivot table definition functions: 
\code{\link{define_labels}()},
\code{\link{get_page}()},
\code{\link{set_page}()}
}
\concept{pivot table definition functions}
