% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_decks.R
\name{choose_deck}
\alias{choose_deck}
\title{Choose from available flashcard decks}
\usage{
choose_deck(
  pattern = NULL,
  choice = NULL,
  repo = "JeffreyRStevens/flashr_decks"
)
}
\arguments{
\item{pattern}{String pattern to search in list of decks.}

\item{choice}{Integer value of choice from list of decks if you already
know which deck you would like to use without listing again.}

\item{repo}{GitHub username and repo for deck repository in the format
of "username/repository". Default value is "JeffreyRStevens/flashr_decks".}
}
\value{
Outputs a list of available built-in flashcard decks to the console, where
the user can choose one of the decks to generate flashcards.
}
\description{
This function prints a list of flashcard decks to the console
and let's the user choose one of the decks. By default, the function searches
the \href{https://github.com/JeffreyRStevens/flashr_decks/}{flashr_decks repo}.
But other GitHub repos can be used.

To narrow the results, include text in the \code{pattern} argument (for example,
\code{choose_deck(pattern = "r4ds")}).
}
\note{
This function \strong{requires internet connectivity} as it checks GitHub repos
for decks.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
# Choose from all available decks in default repository
choose_deck()

# Choose from decks including text matching pattern
choose_deck(pattern = "r4ds")

# Choose from decks from specific repository
choose_deck(repo = "JeffreyRStevens/flashr_decks")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions for finding decks: 
\code{\link{list_decks}()}
}
\concept{functions for finding decks}
