% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flap.R
\name{flap}
\alias{flap}
\title{Forecast Linear Augmented Projection}
\usage{
flap(fc, fc_comp, Phi, res, res_comp, p = seq_len(ncol(fc_comp)))
}
\arguments{
\item{fc}{An \eqn{h} by \eqn{m} matrix of base forecasts of the original
series to be projected. \eqn{h} is the forecast horizon and \eqn{m} is the
total number of series.}

\item{fc_comp}{An \eqn{h} by \eqn{p} matrix of base forecasts of the components
used in the projection. \eqn{h} is the forecast horizon and \eqn{p} is the
total number of components.}

\item{Phi}{A \eqn{p} by \eqn{m} weight matrix mapping the original series into
the components such that \eqn{c_t = \Phi z_t} where \eqn{c_t} is the vector of
components and \eqn{z_t} is the vector of original series.}

\item{res}{A \eqn{T} by \eqn{m} (in-sample) forecast residual matrix of the
original series.}

\item{res_comp}{A \eqn{T} by \eqn{p} (in-sample) forecast residual matrix of
the components.}

\item{p}{The number of components to use in the projection. The default is
trying all the possible number of components capped at the number provided in
the forecast.}
}
\value{
A list of class \code{flap} with each element containing a \eqn{h} by
\eqn{m} matrix of projected forecast of the original series for the corresponding
number of components \code{p}.
}
\description{
Reduces forecast variance by adjusting the forecasts of multivariate time
series to be consistent with the forecasts of linear combinations (components)
of the series by projecting all forecasts onto the space where the linear
constraints are satisfied.
}
\examples{
# Generate example data
# T = 70, m = 20
train <- matrix(rnorm(70 * 20),ncol = 20)

# Obtain the forecast and the residual of the original series
mdl <- apply(train, 2, forecast::ets)
fc <- vapply(mdl, function(mdl) forecast::forecast(mdl, h=12)$mean,
             FUN.VALUE = numeric(12))
res <- vapply(mdl, residuals, FUN.VALUE = numeric(70))

# Obtain components and their forecasts and residuals
pca <- stats::prcomp(train, center = FALSE, scale. = FALSE)
mdl_comp <- apply(pca$x, 2, forecast::ets)
fc_comp <- vapply(mdl_comp, function(mdl) forecast::forecast(mdl, h=12)$mean,
                  FUN.VALUE = numeric(12))
res_comp <- vapply(mdl_comp, residuals,
                   FUN.VALUE = numeric(nrow(pca$x)))
Phi <- t(pca$rotation)

# flap!
flap(fc, fc_comp, Phi, res, res_comp)

}
