% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-methods.R
\name{summary.rjMCMC}
\alias{summary.rjMCMC}
\title{Summarize Results from Reversible Jump MCMC (rjMCMC)}
\usage{
\method{summary}{rjMCMC}(object, digits = 3, level = 0.95, pip_cutoff = 0.1, ...)
}
\arguments{
\item{object}{An object of class rjMCMC containing the output from the \code{rjMCMC} procedure, which includes:
\describe{
\item{fixed_param}{Matrix of posterior samples for exposure intercept and main effect.}
\item{binary_param}{Matrix of posterior samples for binary variable parameters.}
\item{sigma_sq}{Matrix of posterior samples for the residual variance (sigma squared).}
\item{vars_prop_summ}{Posterior inclusion probabilities for candidate variables.}
\item{splines_fitted}{List of matrices containing fitted values for spline terms across iterations.}
\item{data_fit}{Original dataset used in the \code{rjMCMC} procedure.}
\item{candsplineinter}{Names of continuous candidate predictive spline variables.}
\item{candsplinevars}{Names of continuous candidate spline variables.}
\item{candbinaryvars}{Names of binary candidate variables.}
\item{candinter}{Names of interaction terms, which can include spline variables.}
\item{mcmc_specs}{MCMC sampler specifications, including the number of iterations, burn-in, thinning, and chains.}
}}

\item{digits}{Number of digits in summary output (default = 3)}

\item{level}{Credible interval level (default = 0.95)}

\item{pip_cutoff}{Posterior inclusion probability cutoff for reporting effective sample size
and R-squared (default = 0.10)}

\item{...}{Additional arguments to be passed to other methods or functions.}
}
\value{
Prints the following summary information:
\describe{
\item{Model Formula}{The model formula with spline terms wrapped in \code{fbs()}, indicating free-knot B-splines, and interaction terms appropriately formatted.}
\item{Convergence Diagnostics}{Reports any convergence issues based on Geweke diagnostics.}
\item{MCMC Sampler Arguments}{Displays MCMC sampler arguments, including the number of posterior samples, burn-in, thinning, and chains.}
\item{Parameter Estimates}{Posterior mean, standard error, 95\% credible intervals, effective sample size (ESS), Gelman-Rubin statistic (Rhat), and posterior inclusion probabilities (PIP) for binary parameters, exposure intercept, and exposure effect.}
\item{Gaussian Family Parameters}{Posterior summary for the residual standard error (sigma).}
\item{Posterior Inclusion Probabilities for Splines}{Prints the posterior inclusion probabilities for spline terms.}
\item{Plots for Fitted Exposure Effects}{Plots the mean and 95\% credible intervals for each spline term vs fitted exposure effects.}
}
}
\description{
This function provides a detailed summary of the results from the \code{rjMCMC} procedure, including
model information, parameter estimates, posterior inclusion probabilities, convergence diagnostics,
and plots for spline terms. The function also prints the model formula with \code{fbs()} notation for spline terms,
indicating the use of free-knot B-splines.
}
\details{
The function produces detailed summaries similar to those from \code{brms}, including
diagnostics, estimates, posterior inclusion probabilities, and spline effects. The spline terms
are wrapped in \code{fbs()} notation, indicating the use of free-knot B-splines in the model. If the sampler
did not converge, a warning is issued. The function also allows the user to view diagnostic plots for fitted
exposure effects.
}
\examples{
\donttest{
# Example dataset
data("simulated_data")

candsplinevars <- c("X_1")
candbinaryvars <- paste0("Z_", 1:5)
candinter <- c(candsplinevars, candbinaryvars)

results <- rjMCMC(simulated_data, candsplinevars, candbinaryvars, candinter,
                  outcome = "Y", factor_var = "trt")
summary(results)
}

}
