% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{writeDatfile}
\alias{writeDatfile}
\title{User-friendly wrapper for write.table}
\usage{
writeDatfile(x, file, quote=FALSE, sep="\t", na="",
row.names=FALSE, col.names=TRUE, logical_01=FALSE, ...)
}
\arguments{
\item{x}{the object to be written, preferably a matrix or data frame.
If not, it is attempted to coerce x to a data frame.}

\item{file}{either a character string naming a file or a connection open for
writing. "" indicates output to the console.}

\item{quote}{a logical value (TRUE or FALSE) or a numeric vector. If TRUE,
any character or factor columns will be surrounded by double quotes.
If a numeric vector, its elements are taken as the indices of columns to
quote. In both cases, row and column names are quoted if they are written.
If FALSE (default), nothing is quoted.}

\item{sep}{the field separator string. Values within each row of x are
separated by this string.}

\item{na}{the string to use for missing values in the data}

\item{row.names}{either a logical value indicating whether the row names of x
are to be written along with x, or a character vector of row names to be
written.}

\item{col.names}{either a logical value indicating whether the column names
of x are to be written along with x, or a character vector of column names
to be written.}

\item{logical_01}{FALSE (default) or TRUE; if TRUE, logical columns of x
are converted to 0/1/NA numeric values before writing the file}

\item{...}{Further arguments to be passed to write.table}
}
\description{
A wrapper for write.table that has default parameter values for
writing tab-separated files as used in packages fitPoly and fitPolyTools
}
