% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{nscut_measured_flow}
\alias{nscut_measured_flow}
\title{Measured transmission of electricity in Finland from north to south}
\usage{
nscut_measured_flow(start_time_utc = NA, end_time_utc = NA, user_key = NA)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 1 min and unit type MWh/h.
}
\description{
Measured electricity flow in North-South cut in Finland (cut P1). In the graph flow from North to South is positive. The Data before 28.03.2024 is in hourly resolution.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- nscut_measured_flow(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/30
}
