% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{border_measured_electricity_flow_FI_NO}
\alias{border_measured_electricity_flow_FI_NO}
\title{Transmission of electricity between Finland and Norway}
\usage{
border_measured_electricity_flow_FI_NO(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 15 min and unit type MWh/h.
}
\description{
The values in the data have been erroneously instantaneous values. The data will be corrected to a 15-minute average. We'll let you know when the fix is done.Average data can be found correctly on the European transparency platform: https://transparency.entsoe.eu/transmission-domain/physicalFlow/showMeasured electrical transmission between Finland and Norway 220kV tie line. Positive sign means transmission from Finland to Norway. Negative sign means transmission from Norway to Finland. The value is updated once every 15 minutes after the hour shift. Each day before noon the values of the previous day are updated with more accurate measurement values. The Data before 13.06.2023 is in hourly resolution.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- border_measured_electricity_flow_FI_NO(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/57
}
