% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_plot.R
\name{correlation_plot}
\alias{correlation_plot}
\title{Correlation matrix chart}
\usage{
correlation_plot(
  data,
  columns = c(1:ncol(data) - 1),
  mixtures = FALSE,
  nmixtures = 1,
  colors = NULL
)
}
\arguments{
\item{data}{Data frame containing sediment source and mixture data. Users should ensure their data is in a valid format by using the check_database() function before running this function.}

\item{columns}{Numeric vector containing the index of the columns in the chart (the first column refers to the grouping variable)}

\item{mixtures}{Boolean to include or exclude the mixture samples in the chart}

\item{nmixtures}{Number of mixtures in the dataset}

\item{colors}{Vector of colors to use for the scatterplot}
}
\description{
The function displays a correlation matrix of each of the properties divided by the different sources to help the user in the decision.
}
