% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{kmer_count_modify}
\alias{kmer_count_modify}
\title{Modify K-mer Frequency Before Fitting}
\usage{
kmer_count_modify(start, end, left_right, histx)
}
\arguments{
\item{start}{An integer indicating the starting position (does not include the peak position).}

\item{end}{An integer indicating the ending position (does not include the peak position).}

\item{left_right}{An integer indicating whether to modify the left part (0) or the right part (1).}

\item{histx}{A data frame representing the k-mer histogram.}
}
\value{
A modified data frame with adjusted k-mer frequencies.
}
\description{
This function modifies the k-mer frequency before fitting, adjusting either the left or right part based on the peak position.
}
\examples{
histx <- data.frame(V1 = 1:10, V2 = c(100, 200, 300, 400, 500, 400, 300, 200, 100, 50))
histx_new <- kmer_count_modify(3, 7, 0, histx)
}
