% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_het_pos}
\alias{get_het_pos}
\title{Filter Peaks from K-mer Histogram}
\usage{
get_het_pos(histo_data)
}
\arguments{
\item{histo_data}{A data frame representing the k-mer histogram.}
}
\value{
A data frame with filtered peaks.
}
\description{
This function filters peaks from a k-mer histogram to find a major peak with enough support information on both sides.
}
\examples{

x <- seq(-10, 10, length.out = 100)
y <- dnorm(x)
histo_data <- data.frame(V1 = 1:100, V2 = y * 10)
get_het_pos(histo_data)

}
