% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_dbh_bubbles}
\alias{theme_dbh_bubbles}
\title{Theme for \code{theme_dbh_bubbles()}.}
\usage{
theme_dbh_bubbles(
  axis.text = element_blank(),
  panel.background = element_rect(fill = "white"),
  panel.grid.minor = element_blank(),
  panel.grid.major = element_blank(),
  legend.position = "none",
  plot.title = element_text(size = 20),
  plot.subtitle = element_text(size = 12),
  panel.border = element_rect(colour = "black", fill = NA),
  axis.ticks.length = unit(-0.1, "cm"),
  ...
)
}
\arguments{
\item{panel.background}{background of plotting area, drawn underneath plot
(\code{\link[ggplot2:element_rect]{element_rect()}}; inherits from \code{rect})}

\item{legend.position}{the position of legends ("none", "left", "right",
"bottom", "top", or two-element numeric vector)}

\item{plot.title}{plot title (text appearance) (\code{\link[ggplot2:element_text]{element_text()}}; inherits
from \code{title}) left-aligned by default}

\item{plot.subtitle}{plot subtitle (text appearance) (\code{\link[ggplot2:element_text]{element_text()}};
inherits from \code{title}) left-aligned by default}

\item{panel.border}{border around plotting area, drawn on top of plot so that
it covers tick marks and grid lines. This should be used with
\code{fill = NA}
(\code{\link[ggplot2:element_rect]{element_rect()}}; inherits from \code{rect})}

\item{...}{additional element specifications not part of base ggplot2. In general,
these should also be defined in the \verb{element tree} argument.}
}
\description{
Theme for \code{theme_dbh_bubbles()}.
}
\examples{
class(theme_dbh_bubbles())
}
\seealso{
Other functions to plot dbh bubbles: 
\code{\link{header_dbh_bubbles}()},
\code{\link{plot_dbh_bubbles_by_quadrat}()}
}
\concept{functions to plot dbh bubbles}
\keyword{internal}
