% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_model_helpers.R
\name{compute_ibrier}
\alias{compute_ibrier}
\title{Compute Integrated Brier Score and Curve}
\usage{
compute_ibrier(eval_times, surv_mat, time_vec, status_vec, tau, censor_eval_fn)
}
\arguments{
\item{eval_times}{Numeric vector of evaluation time points.}

\item{surv_mat}{Matrix of predicted survival probabilities
(rows=subjects, cols=eval_times).}

\item{time_vec}{Numeric vector of test times.}

\item{status_vec}{Numeric vector of test statuses.}

\item{tau}{The time horizon \eqn{\tau} for integration.}

\item{censor_eval_fn}{A function (from \code{create_censor_eval}) that
evaluates the censoring survival function \eqn{G(t)}.}
}
\value{
A list with \code{ibs} (the scalar IBS value) and \code{curve} (a
  numeric vector of Brier scores at \code{eval_times}).
}
\description{
Calculates the Brier score at specified evaluation times and the
Integrated Brier Score (IBS) up to \eqn{\tau}, using IPCW to handle
censoring.
}
\keyword{internal}
