% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-liureg.R
\name{predict.liureg}
\alias{predict.liureg}
\title{Predict method for liureg objects}
\usage{
\method{predict}{liureg}(object, newdata, ...)
}
\arguments{
\item{object}{A \code{liureg} object.}

\item{newdata}{A data frame of new values for \code{X} at which predictions are to be made.
Can be a \code{data.frame} or a \code{matrix}.}

\item{...}{Not used in this implementation.}
}
\value{
Depending on whether the \code{lambda} is a scalar or a vector,
the \code{predict.liureg} function returns a vector or matrix of predictions, respectively.
}
\description{
Predict method for liureg objects
}
\examples{
data("Hitters")
Hitters <- na.omit(Hitters)
X <- model.matrix(Salary ~ ., Hitters)[, -1]
y <- Hitters$Salary
lam <- seq(0, 1, 0.01)
liu.mod <- liureg(X, y, lam)
# Predictions based on original X matrix.
predict(liu.mod)
# Predictions based on newdata. newdata can be a matrix or a data.frame.
predict(liu.mod, newdata=X[1:5, ])
}
\seealso{
\code{\link[=liureg]{liureg()}}, \code{\link[=predict]{predict()}}, \code{\link[=summary]{summary()}}, \code{\link[=pressliu]{pressliu()}}, \code{\link[=residuals]{residuals()}}
}
\author{
Murat Genç
}
