% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undirected_planted_partition.R
\name{planted_partition}
\alias{planted_partition}
\title{Create an undirected planted partition object}
\usage{
planted_partition(
  n,
  k,
  ...,
  within_block = NULL,
  between_block = NULL,
  a = NULL,
  b = NULL,
  block_sizes = NULL,
  pi = NULL,
  sort_nodes = TRUE,
  poisson_edges = TRUE,
  allow_self_loops = TRUE
)
}
\arguments{
\item{n}{The number of nodes in the network. Must be
a positive integer. This argument is required.}

\item{k}{Number of planted partitions, as a positive integer.
This argument is required.}

\item{...}{
  Arguments passed on to \code{\link[=undirected_factor_model]{undirected_factor_model}}
  \describe{
    \item{\code{expected_degree}}{If specified, the desired expected degree
of the graph. Specifying \code{expected_degree} simply rescales \code{S}
to achieve this. Defaults to \code{NULL}. Do not specify both
\code{expected_degree} and \code{expected_density} at the same time.}
    \item{\code{expected_density}}{If specified, the desired expected density
of the graph. Specifying \code{expected_density} simply rescales \code{S}
to achieve this. Defaults to \code{NULL}. Do not specify both
\code{expected_degree} and \code{expected_density} at the same time.}
  }}

\item{within_block}{Probability of within block edges. Must be
strictly between zero and one. Must specify either
\code{within_block} and \code{between_block}, or \code{a} and \code{b} to determine
edge probabilities.}

\item{between_block}{Probability of between block edges. Must be
strictly between zero and one. Must specify either
\code{within_block} and \code{between_block}, or \code{a} and \code{b} to determine
edge probabilities.}

\item{a}{Integer such that \code{a/n} is the probability of edges
within a block. Useful for sparse graphs. Must specify either
\code{within_block} and \code{between_block}, or \code{a} and \code{b} to determine
edge probabilities.}

\item{b}{Integer such that \code{b/n} is the probability of edges
between blocks. Useful for sparse graphs. Must specify either
\code{within_block} and \code{between_block}, or \code{a} and \code{b} to determine
edge probabilities.}

\item{block_sizes}{(block sizes) Number of nodes in each block,
as a vector of integers. Must match the dimensions of \code{B}, or \code{k} and
must sum to \code{n}. Defaults to \code{NULL}, in which case blocks are made
to be as balanced as possible. You can specify either \code{pi} or
\code{block_sizes}, but not both.}

\item{pi}{(block sizes) Relative block
probabilities. Must be positive, but do not need to sum
to one, as they will be normalized internally.
Must match the dimensions of \code{B} or \code{k}. Defaults to \code{NULL}, in which
case the \code{block_sizes} argument will take precedence. Note that
you can specify either \code{pi} or \code{block_sizes}, but should not
specify both.}

\item{sort_nodes}{Logical indicating whether or not to sort the nodes
so that they are grouped by block and by \code{theta}. Useful for plotting.
Defaults to \code{TRUE}. When \code{TRUE}, nodes are first sorted by block
membership, and then by degree-correction parameters within each block.
Additionally, \code{pi} is sorted in increasing order, and the columns
of the \code{B} matrix are permuted to match the new order of \code{pi}.}

\item{poisson_edges}{Logical indicating whether or not
multiple edges are allowed to form between a pair of
nodes. Defaults to \code{TRUE}. When \code{FALSE}, sampling proceeds
as usual, and duplicate edges are removed afterwards. Further,
when \code{FALSE}, we assume that \code{S} specifies a desired between-factor
connection probability, and back-transform this \code{S} to the
appropriate Poisson intensity parameter to approximate Bernoulli
factor connection probabilities. See Section 2.3 of Rohe et al. (2017)
for some additional details.}

\item{allow_self_loops}{Logical indicating whether or not
nodes should be allowed to form edges with themselves.
Defaults to \code{TRUE}. When \code{FALSE}, sampling proceeds allowing
self-loops, and these are then removed after the fact.}
}
\value{
An \code{undirected_planted_partition} S3 object, which is a subclass
of the \code{\link[=sbm]{sbm()}} object, with additional fields:
\itemize{
\item \code{within_block}: The probability of edge formation within a block.
\item \code{between_block}: The probability of edge formation between two distinct
blocks.
}
}
\description{
To specify a planted partition model, you must specify
the number of nodes (via \code{n}), the mixing matrix (optional, either via
\code{within_block/between_block} or \code{a/b}),
and the relative block probabilites (optional, via \code{pi}).
We provide defaults for most of these options to enable
rapid exploration, or you can invest the effort
for more control over the model parameters. We \strong{strongly recommend}
setting the \code{expected_degree} or \code{expected_density} argument
to avoid large memory allocations associated with
sampling large, dense graphs.
}
\details{
A planted partition model is stochastic blockmodel in which
the diagonal and the off-diagonal of the mixing matrix \code{B}
are both constant. This means that edge probabilities
depend only on whether two nodes belong to the same block,
or to different blocks, but the particular blocks themselves
don't have any impact apart from this.
}
\examples{

set.seed(27)

lazy_pp <- planted_partition(
  n = 100,
  k = 5,
  expected_density = 0.01,
  within_block = 0.1,
  between_block = 0.01
)

lazy_pp

}
\seealso{
Other stochastic block models: 
\code{\link{dcsbm}()},
\code{\link{directed_dcsbm}()},
\code{\link{mmsbm}()},
\code{\link{overlapping_sbm}()},
\code{\link{sbm}()}

Other undirected graphs: 
\code{\link{chung_lu}()},
\code{\link{dcsbm}()},
\code{\link{erdos_renyi}()},
\code{\link{mmsbm}()},
\code{\link{overlapping_sbm}()},
\code{\link{sbm}()}
}
\concept{stochastic block models}
\concept{undirected graphs}
