% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{proc_align}
\alias{proc_align}
\title{Procrustes alignment}
\usage{
proc_align(A,B,return_orth=FALSE)
}
\arguments{
\item{A}{An \eqn{n \times d} matrix.}

\item{B}{An \eqn{n \times d} matrix.}

\item{return_orth}{A Boolean which specifies whether to return the
orthogonal transformation.
Defaults to \code{FALSE}.}
}
\value{
If \code{return_orth} is \code{FALSE}, returns the \eqn{n \times d}
matrix resulting from applying the optimal aligning transformation to
the columns of \code{A}.
Otherwise, returns a list with two entries:
\item{Ao}{The \eqn{n \times d}
matrix resulting from applying the optimal aligning transformation to the
columns of \code{A}.}
\item{orth}{The \eqn{d \times d} optimal aligning orthogonal transformation
matrix.}
}
\description{
\code{proc_align} orthogonally transforms the columns of a matrix \eqn{A} to
find the best approximation (in terms of Frobenius norm) to a
second matrix \eqn{B}. Optionally, it may also return the optimal transformation
matrix.
}
