% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faraway-package.R
\docType{data}
\name{wfat}
\alias{wfat}
\title{Percentage of Body Fat and Body Measurements in Women}
\format{
A data frame with 184 observations on the following 19 variables.
\describe{ 
\item{siri}{ Percent body fat using Siri's equation} 
\item{weight}{ Weight (lbs)}
\item{height}{ Height (inches)} 
\item{bmi}{Body Mass Index}
\item{age}{ Age (yrs)} 
\item{neck}{ Neck circumference (cm)} 
\item{chest}{ Chest circumference (cm)} 
\item{calf}{Calf circumference (cm)}
\item{biceps}{ Extended biceps circumference (cm)} 
\item{hip}{Hip circumference (cm)} 
\item{abdom}{Horizontal minimal measurement, at the end of a normal expiration (cm)}
\item{forearm}{Forearm circumference (cm)}
\item{thigh}{(Proximal Thigh) Horizontal measurement immediately 
distal to the gluteal furrow (cm)}
\item{mthigh}{(Middle Thigh) Measurement midway between the midpoint 
of the inguinal crease and the proximal border of the patella (cm)}
\item{dthigh}{(Distal Thigh) Measurement proximal to the femoral epicondyles (cm)}
\item{wrist}{Wrist circumference (cm) distal to the styloid processes} 
\item{knee}{Knee circumference (cm)} 
\item{elbow}{A minimal circumference measurement with the elbow extended (cm)}
\item{ankle}{Ankle circumference (cm)} }
}
\source{
Roger W. Johnson (2021): Fitting Percentage of Body Fat to Simple Body 
Measurements: College Women, Journal of Statistics and Data Science Education, 
DOI: 10.1080/26939169.2021.1971585 (Note that I have changed some
of the variable names to correspond with the older fat data for men)
}
\description{
Age, weight, height, and 10 body circumference measurements are recorded for
184 women. Each woman's percentage of body fat was accurately estimated by an
underwater weighing technique.
}
\seealso{
\code{\link{fat}}
}
\keyword{datasets}
