% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fakmct.R
\name{fakmct}
\alias{fakmct}
\title{Fuzzy Adaptive Resonance Theory (ART) K-Means Clustering Technique}
\usage{
fakmct(
  input,
  rho,
  alpha,
  beta,
  w_init = NA,
  max_epochs = 1000,
  max_clusters = 1000,
  eps = 10^-6
)
}
\arguments{
\item{input}{The input (vector) data observation. Should be numeric type of data.}

\item{rho}{Vigilance parameter in (0,1)}

\item{alpha}{Choice parameter alpha > 0}

\item{beta}{Learning rate in (0,1)}

\item{w_init}{Initial weight}

\item{max_epochs}{Maximum number of iterations}

\item{max_clusters}{Maximum number of clusters that allowed}

\item{eps}{Tolerance with default is 10^-6}
}
\value{
\item{labels}{clusters label of each observations}
\item{size}{the size of each clusters that have been formed}
\item{clusters}{a list of observations in each clusters}
\item{centroids}{cluster centroids that are calculated by the mean value of the objects in each clusters}
\item{weights}{the model weight}
\item{params}{parameters that have been saved in the function}
\item{num_clusters}{number of cluster that have been formed}
\item{running.time}{time for running function}
}
\description{
Clustering data observation with hybrid method Fuzzy ART and K-Means
}
\examples{
library(fakmct)
# Using dataset iris
## load data
data.inputs = iris[,-5]
true.labels = as.numeric(unlist(iris$Species))

## run model data
ex.iris<-fakmct(data.inputs, alpha = 0.3, rho = 0.5, beta = 1, max_epochs = 50, max_clusters = 5)
ex.iris$labels
ex.iris$size
ex.iris$centroids
ex.iris$params

## plot data
plot(data.inputs, col = ex.iris$labels, pch = true.labels,
     main = paste0("Dataset: Iris"))

# Using data IPM 2019

## load simulate data IPM
data("simulatedataIPM")
dt <- simulatedataIPM

## run model data IPM
mod.fakm<-fakmct(dt, alpha = 0.3, rho = 0.5, beta = 0.1, max_epochs = 50, max_clusters = 5)
mod.fakm$labels
mod.fakm$size
mod.fakm$centroids
mod.fakm$params

## plot data IPM
plot(dt, col = mod.fakm$labels, pch=mod.fakm$labels, main = paste0("Dataset IPM"))
}
