% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multifabCI.R
\name{hhetmodel}
\alias{hhetmodel}
\title{Hierarchical heteroscedastic model estimates}
\usage{
hhetmodel(y, g)
}
\arguments{
\item{y}{a numeric vector of data}

\item{g}{a group membership vector, of the same length as y}
}
\value{
A vector (mu,t2,s20,nu0), where 
\enumerate{
\item mu is the mean of the group means 
\item t2 is the variance of the group means
\item the the distribution of group variances is inverse-gamma(nu0/2,nu0 s20/2)
}
}
\description{
Estimate across-group heterogeneity of means and variances
}
\details{
This function estimates 
parameters in a hierarchical model for normally distributed
groups, where the across-group model for means is normal 
and the across group model for variances is inverse-gamma.
}
\author{
Peter Hoff
}
\keyword{htest}
