% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{pca}
\alias{pca}
\alias{pca.default}
\alias{pca.dfts}
\title{Generic Function for Principal Component Analysis}
\usage{
pca(object, TVE = 1, ...)

\method{pca}{default}(object, ...)

\method{pca}{dfts}(object, TVE = 1, ...)
}
\arguments{
\item{object}{Object for computation of principle components analysis.}

\item{TVE}{Numeric in [0,1] for the total variance explained, this determines
the number of components and can be used for dimension reduction.}

\item{...}{Additional parameters to extensions based on data. Often this is
additional information for \code{prcomp}.}
}
\value{
Principal component data. Note that the scores are in x and the eigenfuctions
in rotation. This is to keep consistency between existing pca methods in R,
but may change in the future.
}
\description{
This is a generic function to call PCA on various objects. The default method
uses \code{\link[stats:prcomp]{stats::prcomp()}}.
}
\examples{
pca(1:10)
pca(electricity)
}
