% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgamma.R
\name{mgamma}
\alias{mgamma}
\alias{dmgamma}
\alias{pmgamma}
\alias{qmgamma}
\alias{rmgamma}
\title{The Gamma Mixture Distribution}
\usage{
dmgamma(x, mu, eta, w, log = FALSE)

pmgamma(q, mu, eta, w, lower.tail = TRUE)

qmgamma(p, mu, eta, w, lower.tail = TRUE)

rmgamma(N, mu, eta, w)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{means of the gamma mixture components (vector).}

\item{eta}{shapes of the gamma mixture components (vector).}

\item{w}{weights of the gamma mixture components (vector). Must sum to one.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P(X\leq x)} otherwise \eqn{P(X>x)}.}

\item{p}{vector of probabilities.}

\item{N}{number of observations.}
}
\value{
\code{dmgamma} gives the density, \code{pmgamma} gives the distribution function, \code{qmgamma} gives the quantile function, and \code{rmgamma} generates random deviates.

The length of the result is determined by \code{N} for \code{rmgamma} and by the length of \code{x}, \code{q} or \code{p} otherwise.
}
\description{
Density, distribution function, quantile function and random generation for the mixture of Gamma distribution.
}
\details{
The Gamma distribution has density \deqn{f_{GA}(x|\mu,\eta)= \frac{(\eta/\mu)^\eta}{\Gamma(\eta)}x^{\eta-1}\exp(-(\eta/\mu)x), \hspace{1cm} x>0,} where \eqn{\mu>0} is the mean of the distribution and \eqn{\eta>0} is its shape.
The density of a mixture of Gamma distributions with \eqn{k} components is defined as  \deqn{f_{MG}(x|\mu,\eta,w)=\sum_{i=1}^k w_if_{GA}(x|\mu_i,\eta_i),} where \eqn{w_i,\mu_i,\eta_i >0}, for \eqn{i=1,\dots,k}, \eqn{w_1+\cdots+w_k=1}, \eqn{\mu=(\mu_1,\dots,\mu_k)}, \eqn{\eta = (\eta_1,\dots,\eta_k)} and \eqn{w=(w_1,\dots,w_k)}.
}
\examples{
dmgamma(3, mu = c(2,3), eta = c(1,2), w = c(0.3,0.7))

}
\references{
Wiper, Michael, David Rios Insua, and Fabrizio Ruggeri. "Mixtures of gamma distributions with applications." Journal of Computational and Graphical Statistics 10.3 (2001): 440-454.
}
