% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{mgus2}
\alias{mgus2}
\title{Monoclonal gammopathy data}
\format{
A data frame with 1384 observations on the following 10 variables.
\describe{
    \item{\code{id}}{subject identifier}
    \item{\code{age}}{age at diagnosis, in years}
    \item{\code{sex}}{a factor with levels \code{F} \code{M}}
    \item{\code{dxyr}}{year of diagnosis}
    \item{\code{hgb}}{hemoglobin}
    \item{\code{creat}}{creatinine}
    \item{\code{mspike}}{size of the monoclonal serum spike}
    \item{\code{ptime}}{time until progression to a plasma cell
        malignancy (PCM) or last contact, in months}
    \item{\code{pstat}}{occurrence of PCM: 0=no, 1=yes }
    \item{\code{futime}}{time until death or last contact, in months}
    \item{\code{death}}{occurrence of death: 0=no, 1=yes}
    \item{\code{etime}}{time until either death, pcm, or last contact}
    \item{\code{event}}{factor indicating which event occurred first}
}
}
\usage{
mgus2
}
\description{
Natural history of 1341 sequential patients with monoclonal gammopathy of undetermined significance (MGUS). This is a superset of the mgus data, at a later point in the accrual process. This dataset is redistributed from the survival package with an added competing risks event indicator.
}
\seealso{
\link[survival]{mgus2}
}
\keyword{datasets}
