% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-team-metadata.R
\name{getTeam}
\alias{getTeam}
\alias{getTeamPeople}
\alias{getTeamGames}
\title{Team metadata}
\usage{
getTeam(season_code, team_code)

getTeamPeople(season_code, team_code)

getTeamGames(season_code, team_code)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{team_code}{One or more team codes as obtained from \code{\link[=getCompetitionTeams]{getCompetitionTeams()}}.\cr
Examples are \code{ASV}, \code{MAD}, ...}
}
\value{
For each function, returns a tibble with information about team,
people or games of chosen season and team code.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Retrieve contextual information about teams.
Outputs may be required as arguments of other \verb{getTeam*} or \verb{getPlayer*} functions.
}
\examples{

\dontrun{

getTeam(team_code = "ASV", season_code = c("E2023", "E2022")) |> head(5)

getTeamPeople(team_code = "ASV", season_code = c("E2023", "E2022")) |> head(5)

getTeamGames(team_code = "ASV", season_code = c("E2023", "E2022")) |> head(5)

}
}
\keyword{teamMetadata}
