% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-player-stats.R
\name{getPlayerStats}
\alias{getPlayerStats}
\title{Get player statistics}
\usage{
getPlayerStats(
  season_code,
  statistic_mode = c("perGame", "perMinute", "accumulated")
)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{statistic_mode}{One or more aggregation modes of statistics.\cr
Admitted values are \code{perGame}, \code{perMinute} and \code{accumulated}.}
}
\value{
Returns a summary tibble of players statistics for chosen seasons.

Glossary of columns:\tabular{ll}{
   \strong{Column name} \tab \strong{Column extended name} \cr
   GP \tab Game player \cr
   GS \tab Game started \cr
   MIN \tab Minutes played \cr
   PTS \tab Points scored \cr
   2PM \tab Two-pointers made \cr
   2PA \tab Two-pointers attempted \cr
   2P\% \tab Two-point \% \cr
   3PM \tab Three-pointers made \cr
   3PA \tab Three-pointers attempted \cr
   3P\% \tab Three-point \% \cr
   FTM \tab Free throws made \cr
   FTA \tab Free throws attempted \cr
   FT\% \tab Free-throw \% \cr
   OREB \tab Offensive rebounds \cr
   DREB \tab Defensive rebounds \cr
   TREB \tab Total rebounds \cr
   AST \tab Assists \cr
   STL \tab Steals \cr
   TO \tab Turnovers \cr
   BLK \tab Blocks \cr
   BLKA \tab Blocks against \cr
   FC \tab Personal fouls committed \cr
   FD \tab Personal fouls drawn \cr
   PIR \tab Performance Index Rating \cr
}


Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/stats/expanded/?size=1000&viewType=traditional&seasonCode=E2023&statisticMode=perGame&seasonMode=Single&sortDirection=descending&statistic=blocksFavour}{Stats}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{

\dontrun{

getPlayerStats(season_code = "E2023", statistic_mode = "perGame")

}

}
