% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.etree}
\alias{predict.etree}
\title{Predictions for Energy Trees}
\usage{
\method{predict}{etree}(object, newdata = NULL, perm = NULL, ...)
}
\arguments{
\item{object}{A fitted Energy Tree of class \code{"etree"}.}

\item{newdata}{Optional set of new covariates used to make predictions.
Must be provided as a list, where each element is a different variable.
Currently available types and the form they need to have to be correctly
recognized are the following:
\itemize{
\item Numeric: numeric or integer vectors;
\item Nominal: factors;
\item Functions: objects of class \code{"fdata"};
\item Graphs: (lists of) objects of class \code{"igraph"}.
}
Each element (i.e., variable) in the covariates list must have the same
\code{length()}, which corresponds to the (new) sample size. If
\code{newdata} is omitted, fitted values are returned.}

\item{perm}{Optional character vector of variable names. Splits of nodes
with a primary split in any of these variables will be permuted (after
dealing with surrogates). Note that surrogate split in the \code{perm}
variables will not be permuted.}

\item{...}{Additional arguments.}
}
\value{
Predictions, in the form of a factor for classification or as a numeric
vector for regression.
}
\description{
Compute predictions for objects of class \code{"etree"} (i.e., fitted Energy
Trees as returned by \code{\link[etree:etree]{etree()}}, or as contained in
the \code{ensemble} element of a fitted Random Energy Forest).
}
\details{
The \code{predict()} method for \code{"etree"} objects yields predictions for
fitted Energy Trees as returned by \code{\link[etree:etree]{etree()}} or as
contained in the \code{ensemble} element of a fitted Random Energy Forest.
Predictions are based either on fitted values (if \code{newdata} is
\code{NULL}) or on the new set of covariates (if \code{newdata} is provided).
The values of \code{split_type} and \code{coeff_split_type}, as well as the
number of components for each structured covariate (needed to compute an
equivalent representation for the covariates in \code{newdata} when
\code{split_type = "coeff"}), are automatically retrieved from the object of
class \code{"etree"}.
}
