% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodes.R
\name{nodeids}
\alias{nodeids}
\alias{nodeids.partynode}
\alias{nodeids.etree}
\alias{nodeids.party}
\title{Extract node identifiers.}
\usage{
nodeids(obj, ...)

\method{nodeids}{partynode}(obj, from = NULL, terminal = FALSE, ...)

\method{nodeids}{etree}(obj, from = NULL, terminal = FALSE, ...)
}
\arguments{
\item{obj}{Object of class \code{"etree"} or \code{"partynode"}.}

\item{...}{Additional arguments.}

\item{from}{Integer specifying the node to start from.}

\item{terminal}{Logical indicating whether only identifiers of terminal nodes
should be returned (\code{FALSE} by default).}
}
\value{
An integer vector of node identifiers.
}
\description{
Extract unique identifiers from inner and terminals nodes of \code{"etree"}
or \code{"partynode"} objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{partynode}: nodeids() method for objects of class "partynode".

\item \code{etree}: nodeids() method for objects of class "etree".
}}

\examples{

\donttest{

## Covariates
nobs <- 100
cov_num <- rnorm(nobs)
cov_nom <- factor(rbinom(nobs, size = 1, prob = 0.5))
cov_gph <- lapply(1:nobs, function(j) igraph::sample_gnp(100, 0.2))
cov_fun <- fda.usc::rproc2fdata(nobs, seq(0, 1, len = 100), sigma = 1)
cov_list <- list(cov_num, cov_nom, cov_gph, cov_fun)

## Response variable
resp_reg <- cov_num ^ 2

## Fit
etree_fit <- etree(response = resp_reg, covariates = cov_list)

## Get all nodes identifiers
nodes_ids <- nodeids(etree_fit)

## Get terminal nodes identifiers
tnodes_ids <- nodeids(etree_fit, terminal = TRUE)

## Get all nodes identifiers starting from 2
nodes_ids2 <- nodeids(etree_fit, from = 2)
}
}
