% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_metrics.R
\name{plot_small_metrics}
\alias{plot_small_metrics}
\title{Plot Small Sample Metrics}
\usage{
plot_small_metrics(
  x,
  colors = NULL,
  title = NULL,
  save = FALSE,
  path = NULL,
  name = "myplot.pdf",
  width = 15,
  height = 8
)
}
\arguments{
\item{x}{A data.frame. The result of \code{small_metrics()}.}

\item{colors}{character. The colors to be used in the plot.}

\item{title}{character. The plot title.}

\item{save}{logical. Should the plot be saved?}

\item{path}{A path to the directory in which the plot will be saved.}

\item{name}{character. The name of the output pdf file.}

\item{width}{numeric. The plot width in inches.}

\item{height}{numeric. The plot height in inches.}
}
\value{
The plot is returned invisibly in the form of a \code{ggplot} object.
}
\description{
This function provides an easy way to illustrate the output of
\code{small_metrics()}, using the \code{ggplot2} package. A grid of line charts is
created for each metric and sample size. Each estimator is plotted with a
different color and linetype. The plot can be saved in pdf format.
}
\examples{
\donttest{
D <- Beta(shape1 = 1, shape2 = 2)

prm <- list(name = "shape1",
            pos = NULL,
            val = seq(0.5, 2, by = 0.5))

x <- small_metrics(D, prm,
                   est = c("mle", "me", "same"),
                   obs = c(20, 50),
                   sam = 1e2,
                   seed = 1)

plot_small_metrics(x)
}
}
\seealso{
\link{small_metrics}, \link{large_metrics}, \link{plot_large_metrics}
}
