% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Multinom.R
\name{Multinom}
\alias{Multinom}
\alias{d,Multinom-method}
\alias{r,Multinom-method}
\alias{mean,Multinom-method}
\alias{var,Multinom-method}
\alias{finf,Multinom-method}
\alias{ll,matrix,numeric,Multinom-method}
\alias{mle,matrix,Multinom-method}
\alias{me,matrix,Multinom-method}
\alias{avar_mle,Multinom-method}
\alias{avar_me,Multinom-method}
\title{Multinomial Distribution}
\usage{
Multinom(size = 1, prob = c(0.5, 0.5))

\S4method{d}{Multinom}(x)

\S4method{r}{Multinom}(x)

\S4method{mean}{Multinom}(x)

\S4method{var}{Multinom}(x)

\S4method{finf}{Multinom}(x)

\S4method{ll}{matrix,numeric,Multinom}(x, prm, distr)

\S4method{mle}{matrix,Multinom}(x, distr)

\S4method{me}{matrix,Multinom}(x, distr)

\S4method{avar_mle}{Multinom}(distr)

\S4method{avar_me}{Multinom}(distr)
}
\arguments{
\item{size, prob}{numeric. The distribution parameters.}

\item{x}{an object of class \code{Multinom}. If the function also has a \code{distr}
argument, \code{x} is a numeric vector, a sample of observations.}

\item{prm}{numeric. A vector including the distribution parameters.}

\item{distr}{an object of class \code{Multinom}.}
}
\value{
The dpqr family of functions return the evaluated density, cumulative
probability, quantile, and random sample, respectively.
The moments family of functions return the appropriate theoretical moment,
as calculated by the distribution true parameters.
The ll function returns the evaluated log-likelihood, given a sample and the
theoretical parameters.
The estim family of functions return the estimated parameters of the
distribution, given a sample.
The avar family of functions return the asymptotic variance or variance -
covariance matrix (if there are two or more parameters) of the corresponding
estimation method.
Calculus performed on Distribution objects returns a Distribution object of
the appropriate class and with the appropriate parameters.
}
\description{
Multinomial Distribution
}
