#' esItems
#
#' @description esItems registers the ESM questionnaire items as opposed to variables containing information about the questionnaire, e.g. the time stamps of when it was started and finished.
#
#' @param dfList a list. Each element of the list must be a data.frame. Each data.frame is a separate raw ESM dataset/an ESM questionnaire version. If there is just one ESM version the list therefore contains one data.frame.
#
#' @param RELEVANTVN_ES a list. This list is generated by function \code{\link{setES}} and it is extended once either by function \code{\link{genDateTime}} or by function \code{\link{splitDateTime}}.
#
#' @return A list with all the item names per ESM questionnaire version. Columns specifying dates, times, or IMEI numbers - as specified in function \code{\link{setES}} - are not used in function \code{\link{esPlausible}}, which takes the result of \code{esItems} as 2nd argument.
#
#' @examples
#' # o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
#' # Prerequisites in order to execute esItems. Start ------------------
#' # Use example list delivered with the package
#' RELEVANTVN_ES <- RELEVANTVN_ESext
#' # keyLsNew is a list of datasets, also delivered with the package
#' rmInvLs <- rmInvalid(keyLsNew, RELEVANTVN_ES)
#' # Prerequisites in order to execute esItems. End --------------------
#' # -------------------------------------------------------
#' # Run function 11 of 29; see esmprep functions' hierarchy.
#' # -------------------------------------------------------
#' # Extract the item names of the raw ESM datasets. rmInvLs[["dfValid"]]
#' # is one of the results from function 'rmInvalid'
#' plausibItems <- esItems(dfList=rmInvLs[["dfValid"]], RELEVANTVN_ES)
#' # o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
#
#' @seealso Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 11 of 29).
#
#' @export
#
esItems <- function(dfList, RELEVANTVN_ES=NULL) {

    dfCheck <- sapply(dfList, FUN = is.data.frame)

    # If at least one of the elements in dfList is not of type data.frame
    # stop the processing.
    if(any(dfCheck == FALSE)) {
        stop("Error in argument 'dfList'. It must be of type 'list'. All elements in the list must be of type 'data.frame'.")
    }
	
	
	# Error handling function for all set-up lists generated by setES and setREF.
    # Both lists RELEVANTVN_ES and RELEVANTVN_REF get extended either by function
    # genDateTime or by function splitDateTime!
    SETUPLISTCheck(RELEVANTINFO_ES=NULL,
    			   RELEVANTVN_ES=RELEVANTVN_ES,
    			   RELEVANTVN_REF=NULL)
	
     # Columns that are known not to be actual questionnaire items.
     notItemsVec <- c("KEY", as.character(unlist(RELEVANTVN_ES)))

    for(i in 1:length(dfList)) {
        if(any(is.na(match(notItemsVec, names(dfList[[i]]))))) {
            idxColNamesNotFound <- which(is.na( match(notItemsVec, names(dfList[[i]]))))
            colNamesNotFound <- names(dfList[[i]])[idxColNamesNotFound]
            stop(paste0("In data frame no. ", i, " within the list the column name(s) ", colNamesNotFound, " can't be found."))
        }
    }

    ESItems <- list()
    for(j in 1:length(dfList)) {
        ESItems[[names(dfList)[j]]] <- names(dfList[[j]])[-match(notItemsVec, names(dfList[[j]]))]
    }

    # RETURN list containing data frames
    # ----------------------------------
    ESItems
}
