% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{back_quote}
\alias{back_quote}
\title{Back Quote Object}
\usage{
back_quote(x, recursive = TRUE, as_double = TRUE)
}
\arguments{
\item{x}{An R object.}

\item{recursive}{Optional. \code{TRUE} or \code{FALSE} which indicates if to
back quote each item of \code{x} or to back quote \code{x} as a whole, when \code{x}
is a vector. The default value is \code{TRUE}.}

\item{as_double}{Optional. \code{TRUE} or \code{FALSE} which indicates if to
differentiate between type double and integer. The default value is
\code{TRUE}, which means integers are handled as doubles.}
}
\value{
A character vector.
}
\description{
Convert an R object to character and add back quotations.
}
\examples{
back_quote(1:3)

back_quote(1:3, recursive = FALSE)

back_quote(1:3, as_double = FALSE)

back_quote(NULL)

back_quote(list(c, 1:3, "a"))
}
