% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.sign.R
\name{gwesf-ergmTerm}
\alias{gwesf-ergmTerm}
\alias{InitErgmTerm.gwesf}
\title{Geometrically weighted edgewise shared friend distribution}
\usage{
# binary: gwesf(decay, fixed=FALSE, cutoff=30, type="OTP", base=NULL, in_order=FALSE)
}
\arguments{
\item{decay}{nonnegative decay parameter for the shared friend or selected directed analogue count; required if `fixed=TRUE` and ignored with a warning otherwise.}

\item{fixed}{optional argument indicating
whether the `decay` parameter is fixed at the given value, or is to be fit as a curved
exponential-family model (see Hunter and Handcock, 2006). The
default is `FALSE` , which means the scale parameter is not
fixed and thus the model is a curved exponential family.}

\item{lag}{logical; if TRUE, compute the lagged version of the gwesf statistic based on the previous time point's network}

\item{cutoff}{This optional argument sets the number of underlying ESF terms
to use in computing the statistics when `fixed=FALSE`, in order to reduce
the computational burden.  Its default value can also be controlled by the
`gw.cutoff` term option control parameter. (See `?control.ergm`.)}

\item{type}{A string indicating the type of shared partner or path to be considered for directed networks: `"OTP"` (default for directed), `"ITP"`, `"RTP"`, `"OSP"`, and `"ISP"`; has no effect for undirected. See the section below on Shared partner types for details.}

\item{base}{specify the base of the triad, either by '+' and '-' or 1 and -1}
}
\description{
This term adds a statistic equal to the geometrically weighted edgewise (not dyadwise) shared friend distribution with decay parameter. For a directed network, multiple shared friend definitions are possible.
}
\note{
This term takes an additional term option (see
  [`options?ergm`][ergm-options]), `cache.sp`, controlling whether
  the implementation will cache the number of shared partners for
  each dyad in the network; this is usually enabled by default.
}
\section{Shared partner types}{
 While there is only one shared partner configuration in the undirected
  case, nine distinct configurations are possible for directed graphs, selected
  using the `type` argument. Currently, terms may be defined with respect to
  five of these configurations; they are defined here as follows (using
  terminology from Butts (2008) and the `relevent` package):
-  Outgoing Two-path (`"OTP"`): vertex \eqn{k} is an OTP shared partner of ordered
   pair \eqn{(i,j)} iff \eqn{i \to k \to j}{i->k->j}. Also known as "transitive
   shared partner".
- Incoming Two-path (`"ITP"`): vertex \eqn{k} is an ITP shared partner of ordered
   pair \eqn{(i,j)} iff \eqn{j \to k \to i}{j->k->i}. Also known as "cyclical shared
   partner"
- Reciprocated Two-path (`"RTP"`): vertex \eqn{k} is an RTP shared partner of ordered
   pair \eqn{(i,j)} iff \eqn{i \leftrightarrow k \leftrightarrow j}{i<->k<->j}.
- Outgoing Shared Partner (`"OSP"`): vertex \eqn{k} is an OSP shared partner of
   ordered pair \eqn{(i,j)} iff \eqn{i \to k, j \to k}{i->k, j->k}.
- Incoming Shared Partner (`"ISP"`): vertex \eqn{k} is an ISP shared partner of ordered
   pair \eqn{(i,j)} iff \eqn{k \to i, k \to j}{k->i, k->j}.
By default, outgoing two-paths (`"OTP"`) are calculated. Note that Robins et al. (2009)
  define closely related statistics to several of the above, using slightly different terminology.
}

\seealso{
[`ergmTerm`] for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "gwesf", "subsection")}
}
\concept{directed}
\concept{undirected}
