% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equivTest_FixedMargin.R
\name{equivTestFixedMargin}
\alias{equivTestFixedMargin}
\title{Conduct the equivalence test with fixed margin}
\usage{
equivTestFixedMargin(vecT, vecR, alpha = 0.05, marginX = 1.5,
  sampleSizeX = 1.5, qa = "", sigmaTOverride = NULL,
  labelT = "Proposed", labelR = "Reference", show.message = FALSE,
  method = "Fixed Margin")
}
\arguments{
\item{vecT}{the sample data for test product, can be a vector of observed values or a list returned by \code{createEquivTestSmpl}}

\item{vecR}{the sample data for reference product, can be a vector of observed values or a list returned by \code{createEquivTestSmpl}}

\item{alpha}{the nominal size, default = 0.05}

\item{marginX}{the margin multiplier, default = 1.5}

\item{sampleSizeX}{the sample size adjustment coefficient, default = 1.5}

\item{qa}{a string representing the name of the quality attribute, default = ""}

\item{sigmaTOverride}{a numeric value to override the estimate for standard deviation of the test product}

\item{labelT}{the name of the test product, default = "Proposed"}

\item{labelR}{the name of the reference product, default = "Reference"}

\item{show.message}{a logic value indicating whether messages are to be shown, default = FALSE}

\item{method}{a string indicating the method used in the equivalence test.}
}
\value{
a list of objects summarizing the data and test results, in particular, \code{rslt} = 1 if  \eqn{H_0} is rejected, and \code{rslt} = 0 if \eqn{H_0} is not rejected.
}
\description{
Conduct the equivalence test with fixed margin.
}
\examples{
vecT = rnorm(20,-1.5,1)
vecR = rnorm(20,0,1)
et = equivTestFixedMargin(vecT, vecR)

}
\references{
{
\insertRef{tsong2017development}{equivalenceTest}
}
}
