% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpPartialDisparities.R
\name{getSpPartialDisparities}
\alias{getSpPartialDisparities}
\title{Partial Disparity}
\usage{
getSpPartialDisparities(dat, groupMean = NULL)
}
\arguments{
\item{dat}{matrix of multivariate morphological data}

\item{groupMean}{if \code{NULL}, calculated from \code{dat}, otherwise can
be provided as a vector of mean values}
}
\value{
numeric vector
}
\description{
Calculate species-specific partial disparity, relative to some
  group mean.
}
\details{
Calculates partial disparities, as in Foote 1993. By default, the
  group mean is calculated from the full input data.
}
\examples{
tamiasTraits[1:5, 1:5]
getSpPartialDisparities(tamiasTraits)


}
\author{
Pascal Title
}
