% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensity-classes.R
\name{mapped_var}
\alias{mapped_var}
\alias{mapped_var<-}
\title{Existing variable mappings.}
\usage{
mapped_var(x)

mapped_var(x, keep = TRUE) <- value
}
\arguments{
\item{x}{An \code{intensity} object.}

\item{keep}{Logical. Do we keep any previous mapped variables that are not
redifined in the \code{mapping} object?}

\item{value}{A \code{mapping} object.}
}
\value{
\code{mapped_var} returns the list of current mapped names of the object
\code{x}.
}
\description{
Get or set existing variable mappings.
}
\examples{
my_data <- count(aphids)
my_data
mapped_var(my_data)
mapped_var(my_data) <- mapping(x = X, y = Y)
mapped_var(my_data)
mapped_var(my_data) <- mapping(x = x, r = r, keep = FALSE)
mapped_var(my_data)

}
\seealso{
\code{\link{mapping}}
}
