% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter-utils.R
\name{create_method_assess}
\alias{create_method_assess}
\title{Specify methodological aspects of distribution fitting}
\usage{
create_method_assess(
  censored = NA,
  right_truncated = NA,
  phase_bias_adjusted = NA
)
}
\arguments{
\item{censored}{A boolean \code{logical} whether the study used single or double
interval censoring in the methods to infer the delay distribution}

\item{right_truncated}{A boolean \code{logical} whether the study used right-
truncation in the methods to infer the delay distribution}

\item{phase_bias_adjusted}{A boolean \code{logical} whether the study adjusted for
phase bias in the methods to infer the delay distribution}
}
\value{
A named list with three elements
}
\description{
A helper function when creating an \verb{<epiparameter>} object to
create a method assessment list with sensible defaults, type checking and
arguments to help remember which method assessments can be accepted in
the list.
}
\details{
Currently, the method assessment focuses on common methodological
aspects of delay distributions (e.g. incubation period, serial interval,
etc.), and does not currently take into account methodological aspects which
may be important when fitting offspring distributions to data on disease
(super)spreading.
}
\examples{
create_method_assess(
  censored = FALSE,
  right_truncated = FALSE,
  phase_bias_adjusted = FALSE
)
}
