% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.init_susc_pop}
\alias{.init_susc_pop}
\title{Adjust next generation vector to match susceptible population size}
\usage{
.init_susc_pop(pop, percent_immune, index_cases)
}
\arguments{
\item{pop}{Population size; An \verb{<Integer>}. Used alongside \code{percent_immune}
to define the susceptible population. Defaults to \code{Inf}.}

\item{percent_immune}{Percent of the population immune to
infection at the start of the simulation; A \verb{<numeric>} between 0 and 1.
Used alongside \code{pop} to initialise the susceptible population. Defaults to
0.}
}
\value{
Initial susceptible population size; A numeric coercible to integer.
}
\description{
Calculates the initial susceptible population size given
the total population size, the percent immune, and the number of index
cases. This function is used internally, and input checking is not
performed here, only in the context where it is used. Using it directly
is not recommended.
}
\keyword{internal}
