% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borel.R
\name{rgborel}
\alias{rgborel}
\title{Generate random numbers from a Gamma-Borel mixture distribution}
\usage{
rgborel(n, size, prob, mu, censor_at = Inf)
}
\arguments{
\item{n}{Number of random variates to generate.}

\item{size}{The dispersion parameter (often called \code{k} in ecological
applications); A positive number.}

\item{prob}{Probability of success (in the parameterisation with
\code{prob}, see also \code{\link[stats]{NegBinomial}}); A number between
0 and 1.}

\item{mu}{Mean; A positive number.}

\item{censor_at}{A stopping criterion; \verb{<numeric>}. Defaults to \code{Inf}. A
value above which the simulation ends and the random number is set to
\code{Inf} (as a form of censoring). \code{rborel()} simulates chain sizes using
\code{\link[=simulate_chain_stats]{simulate_chain_stats()}} with a Poisson offspring distribution, so if
\code{mu >= 1}, the simulation could proceed unendingly. This parameter is used
to prevent this.}
}
\value{
Numeric vector of random numbers
}
\description{
Generate random numbers from a Gamma-Borel mixture distribution
}
\examples{
set.seed(32)
rgborel(n = 5, size = 0.3, mu = 1, censor_at = 5)
}
\author{
Sebastian Funk James M. Azam
}
