% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{smoothing}
\alias{smoothing}
\title{Kernel regression smoothing}
\usage{
smoothing(x = c(1:length(y)), y, bandwidth.type = "local",
  bandwidth.value = NULL, kernel.order = 2)
}
\arguments{
\item{x}{data values.
Supported data types
\itemize{
  \item{a numeric vector}
  \item{a time series object \code{ts}}
  \item{a time series object \code{xts}}
  \item{a time series object \code{zoo}}
}}

\item{y}{a numeric vector of data values.}

\item{bandwidth.type}{a character string specifying the type of bandwidth.

Possible options are
\itemize{
  \item{\code{"local"}} {(default) to use local bandwidth}
  \item{\code{"global"}} {to use global bandwidth}
}}

\item{bandwidth.value}{a local bandwidth array (for \code{bandwidth.type = "local"}) or global bandwidth value (for \code{bandwidth.type = "global"}) for kernel regression estimation. If \code{bandwidth.type = "NULL"} (default), a data-adaptive local plug-in (Herrmann, 1997) (for \code{bandwidth.type = "local"}) or data-adaptive global plug-in (Gasser et al., 1991) (for \code{bandwidth.type = "global"}) bandwidth is used instead.}

\item{kernel.order}{a nonnegative integer giving the order of the optimal kernel (Gasser et al., 1985) used for smoothing.

Possible options are
\itemize{
  \item{\code{kernel.order = 2}} {(default)}
  \item{\code{kernel.order = 4}}
}}
}
\value{
A list is returned with elements:
\item{data.smoothed}{a numeric vector of estimates of the kernel regression function (smoothed data).}
\item{residuals}{a numeric vector of smoothing residuals}
}
\description{
Nonparametric estimation of regression function using kernel regression with local or global data-adaptive plug-in bandwidth and optimal kernels.
}
\details{
This function computes the estimate of kernel regression function using a local or global data-adaptive plug-in algorithm and optimal kernels (Gasser et al., 1985).
}
\examples{
data("mydata", package = "openair")
x = mydata$o3[format(mydata$date, "\%m \%Y") == "12 2002"]
smoothed = smoothing(y = x)
smoothed$data.smoothed
smoothed$residuals
}
\references{
Gasser T, Kneip A, Kohler W (1991). A flexible and fast method for automatic smoothing. Journal of the American Statistical Association, 86, 643-652.

Herrmann E (1997). Local bandwidth choice in kernel regression estimation. Journal of Computational and Graphical Statistics, 6(1), 35-54.

Gasser, T, Müller, H-G, Mammitzsch, V (1985). Kernels for nonparametric curve estimation. Journal of the Royal Statistical Society, B Met., 47(2), 238-252.

Eva Herrmann; Packaged for R and enhanced by Martin Maechler (2016). lokern: Kernel Regression Smoothing with Local or Global Plug-in Bandwidth. R package version 1.1-8. https://CRAN.R-project.org/package=lokern
}
