% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremevalue.R
\name{extremal.index.Kgaps}
\alias{extremal.index.Kgaps}
\title{Extremal index estimation (Suveges and Davison, 2010) - Only intended for developer use}
\usage{
extremal.index.Kgaps(x, u, K)
}
\arguments{
\item{x}{a numeric vector of observations.}

\item{u}{a numeric value giving threshold.}

\item{K}{a nonnegative integer giving the value of K parameter (Suveges and Davison, 2010).}
}
\value{
a numeric value of an extremal index estimate
}
\description{
Estimation of an extremal index using the K-gaps estimator suggested in (Suveges and Davison, 2010).
The function is called by \code{\link{KRDetect.outliers.EV}} and is not intended for use by regular users of the package.
}
\details{
This function computes the K-gaps estimate of extremal index suggested in (Suveges and Davison, 2010).
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function used within \code{\link{KRDetect.outliers.EV}}.
}
\references{
Suveges, M, Davison, AC (2010). Model Misspecification in Peaks Over Threshold Analysis. The Annals of Applied Statistics, 4(1), 203-221.
}
