% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.R
\name{changepoint}
\alias{changepoint}
\title{Changepoint analysis - Only intended for developer use}
\usage{
changepoint(x, cp.analysis.type, pen.value, alpha.edivisive)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{cp.analysis.type}{a character string specifying the type of changepoint analysis

Possible options are
\itemize{
  \item{\code{"parametric"}} {to perform changepoint analysis using PELT algorithm (Killick et al., 2012)}
  \item{\code{"nonparametric"}} {to perform a nonparametric approach for multiple changepoins (Matteson and James, 2014)}
}}

\item{pen.value}{A character string giving the formula for manual penalty used in PELT algorithm.
Only required for \code{cp.analysis.type = "parametric"}.}

\item{alpha.edivisive}{a numeric value giving the moment index used for determining the distance between and within segments in the nonparametric changepoint model.}
}
\value{
A list is returned with elements:
\item{x}{a numeric vector of data values}
\item{cp.segmet}{an estimated integer membership vector for individual segments}
}
\description{
Performs changepoint analysis using PELT algorithm or A Nonparametric Approach for Multiple Changepoints.
The function is called by \code{\link{KRDetect.outliers.changepoint}} and is not intended for use by regular users of the package.
}
\details{
This function performs changepoint analysis using parametric or nonparametric approach.
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function for partitioning smoothing residuals into homogeneous segments.
}
\references{
Killick R, Fearnhead P, Eckley IA (2012). Optimal detection of changepoints with a linear computational cost. Journal of the American Statistical Association, 107(500), 1590–1598.

Matteson D, James N (2014). A Nonparametric Approach for Multiple Change Point Analysis of Multivariate Data. Journal of the American Statistical Association, 109(505), 334–345.

Nicholas A. James, David S. Matteson (2014). ecp: An R Package for Nonparametric Multiple Change Point Analysis of Multivariate Data. Journal of Statistical Software, 62(7), 1-25, URL "http://www.jstatsoft.org/v62/i07/".

Killick R, Haynes K, Eckley IA (2016). changepoint: An R package for changepoint analysis. R package version 2.2.2, <URL: https://CRAN.R-project.org/package=changepoint>.
}
