% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voter_profile.R
\name{voter_profile}
\alias{voter_profile}
\title{Download data on the voters' profile}
\usage{
voter_profile(year, encoding = "windows-1252", temp = TRUE, readme_pdf = FALSE)
}
\arguments{
\item{year}{Election year (\code{integer}). For this function, the following years are available: 1998,
2000, 2002, 2004, 2006, 2008, 2010, 2012, 2014, 2016, 2018, 2020, 2022, and 2024.}

\item{encoding}{Data original encoding (defaults to 'windows-1252'). This can be changed to avoid errors
when \code{ascii = TRUE}.
#'}

\item{temp}{(\code{logical}). If \code{TRUE}, keep the temporary compressed file for future use (recommended)}

\item{readme_pdf}{original readme}
}
\value{
\code{voter_profile()} returns a \code{data.frame}.
}
\description{
\code{voter_profile()} downloads and cleans data on the voters' profile aggregated by state, city and electoral zone.
The function returns a \code{data.frame} where each observation corresponds to a voter profile type.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\examples{
\dontrun{
df <- voter_profile(2002)
}
}
