% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trinomial.R
\name{trinomial.bound}
\alias{trinomial.bound}
\title{Auditing with the Trinomial Bound: trinomial.bound and trinomial.audit}
\usage{
trinomial.bound(
  n = 11,
  k = 2,
  d = 40,
  e.max = 100,
  xlim = c(0.4, 1),
  ylim = c(0, 0.55),
  alpha.lvls = c(10),
  zero.threshold = 0.3,
  tick.lines = NULL,
  alpha.lwd = 2,
  bold.first = FALSE,
  plot = TRUE,
  p.value.bound = NULL,
  grid.resolution = 300,
  ...
)
}
\arguments{
\item{n}{Size of the sample (not precincts, but samples which could
potentially be multiple samples of the same precinct).}

\item{k}{The number of positive taints found in sample.}

\item{d}{The maximum size of a small taint. This is the threshold for being
in the middle bin of the trinomial.  All taints larger than d would be in
the largest error bin.}

\item{e.max}{The size of the largest error bin.  Typically 100 (for percent)
or 1.}

\item{xlim}{Range of possible values of p0 worth considering}

\item{ylim}{Range of possible values of pd worth considering}

\item{alpha.lvls}{List of alphas for which bounds should be calculated. The
first is the one that will be returned.  The others will be graphed.}

\item{zero.threshold}{Since the method calculates on a numerical grid, what
difference between alpha and the calculated probabilty should be considered
no difference.}

\item{tick.lines}{A list of bounds.  For these bound levels, add tick-lines
(more faint lines) to graph}

\item{alpha.lwd}{Line width for alpha line.}

\item{bold.first}{TRUE/FALSE.  Should first alpha line be in bold.}

\item{plot}{Should a plot be generated.}

\item{p.value.bound}{What is the bound (1/U) that would correspond to the
entire margin.  Finding the alpha corresponding to this bound is a method
for finding the p-value for the trinomial bound test.}

\item{grid.resolution}{How many divisions of the grid should there be?  More
gives greater accuracy in the resulting p-values and bounds.}

\item{\dots}{Extra arguments passed to the plot command.}
}
\value{
List with characteristics of the audit and the final results.
\item{n}{ Size of sample.} \item{k}{Number of non-zero taints.}
\item{d}{Threshold for what a small taint is.} \item{e.max}{The worst-case
taint.} \item{max}{ The upper confidence bound for the passed alpha-level.}
\item{p}{A length three vector.  The distribution (p0, pd, p1) that achieves
the worst case.} \item{p.value}{ The p.value for the test, if a specific
worst-case bound 1/U was passed via p.value.bound.}
}
\description{
This method makes a contour plot of the optimization problem.
}
\details{
Note: alphas are multiplied by 100 to get in percents.
}
\examples{


# The reported poll data: make an elec.data object for processing
data(santa.cruz)
Z = elec.data(santa.cruz, C.names=c("leopold","danner"))
Z

# Make a plan
plan = tri.calc.sample( Z, beta=0.75, guess.N = 10, p_d = 0.05,
               swing=10, power=0.9, bound="e.plus" )

# Conduct the audit
data(santa.cruz.audit)
res = trinomial.audit( Z, santa.cruz.audit )
res

# Compute the bound.  Everything is scaled by 100 (i.e. to percents) for easier numbers. 
trinomial.bound(n=res$n, k = res$k, d=100*plan$d, e.max=100, p.value.bound=100/plan$T,
           xlim=c(0.75,1), ylim=c(0.0,0.25),
           alpha.lvls=c(25), asp=1,
           main="Auditing Santa Cruz with Trinomial Bound" )

}
\references{
See Luke W. Miratrix and Philip B. Stark.  (2009) Election
Audits using a Trinomial Bound.  https://www.stat.berkeley.edu/~stark/Vote/index.htm
}
\seealso{
See \code{\link{elec.data}} for information on the object that holds vote
counts.  See \code{\link{tri.sample}} for drawing the actual sample.  See
\code{\link{tri.calc.sample}} for figuring out how many samples to draw.
See \code{\link{tri.audit.sim}} for simulating audits using this method.
See \link{CAST.audit} for an SRS audit method.
}
