% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compiler-backends.R
\name{BackendRegistry}
\alias{BackendRegistry}
\title{Singleton Backend Registry, managing all available backends.}
\description{
Contains global backend pool, ensuring backends are only loaded if
actually required.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BackendRegistry-get_backend}{\code{BackendRegistry$get_backend()}}
\item \href{#method-BackendRegistry-get_backend_from_type}{\code{BackendRegistry$get_backend_from_type()}}
\item \href{#method-BackendRegistry-register_backend}{\code{BackendRegistry$register_backend()}}
\item \href{#method-BackendRegistry-unregister_backend}{\code{BackendRegistry$unregister_backend()}}
\item \href{#method-BackendRegistry-add_backend_alias}{\code{BackendRegistry$add_backend_alias()}}
\item \href{#method-BackendRegistry-clear_testing_backends}{\code{BackendRegistry$clear_testing_backends()}}
\item \href{#method-BackendRegistry-get_supported_types}{\code{BackendRegistry$get_supported_types()}}
\item \href{#method-BackendRegistry-get_dependencies}{\code{BackendRegistry$get_dependencies()}}
\item \href{#method-BackendRegistry-is_loadable}{\code{BackendRegistry$is_loadable()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BackendRegistry-get_backend"></a>}}
\if{latex}{\out{\hypertarget{method-BackendRegistry-get_backend}{}}}
\subsection{Method \code{get_backend()}}{
detect the return relevant backend from the input
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRegistry$get_backend(tensor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tensor}}{any supported tensor-like class}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A singleton instance of a \code{\link[=EinopsBackend]{EinopsBackend()}} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BackendRegistry-get_backend_from_type"></a>}}
\if{latex}{\out{\hypertarget{method-BackendRegistry-get_backend_from_type}{}}}
\subsection{Method \code{get_backend_from_type()}}{
Get a backend instance for a specific tensor type.
If the backend is not loaded, it will be instantiated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRegistry$get_backend_from_type(tensor_class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tensor_class}}{A string representing the tensor type.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of the backend class for the specified tensor type.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BackendRegistry-register_backend"></a>}}
\if{latex}{\out{\hypertarget{method-BackendRegistry-register_backend}{}}}
\subsection{Method \code{register_backend()}}{
Register a new backend singleton
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRegistry$register_backend(
  tensor_type,
  backend_class_thunk,
  dependencies = character(0),
  testing = FALSE,
  aliases = character(0)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tensor_type}}{a string with the tensor type the backend supports}

\item{\code{backend_class_thunk}}{a \code{\link[=thunk]{thunk()}}'ed EinopsBackend subclass generator}

\item{\code{dependencies}}{a character vector of required package names}

\item{\code{testing}}{logical flag indicating if this is a testing-only backend}

\item{\code{aliases}}{a character vector of aliases for the tensor type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
this object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BackendRegistry-unregister_backend"></a>}}
\if{latex}{\out{\hypertarget{method-BackendRegistry-unregister_backend}{}}}
\subsection{Method \code{unregister_backend()}}{
Unregister a backend for a specific tensor type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRegistry$unregister_backend(tensor_type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tensor_type}}{a string with the tensor type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
this object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BackendRegistry-add_backend_alias"></a>}}
\if{latex}{\out{\hypertarget{method-BackendRegistry-add_backend_alias}{}}}
\subsection{Method \code{add_backend_alias()}}{
Add an alias for a backend type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRegistry$add_backend_alias(alias, tensor_type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alias}}{a string with the alias name}

\item{\code{tensor_type}}{a string with the canonical tensor type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
this object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BackendRegistry-clear_testing_backends"></a>}}
\if{latex}{\out{\hypertarget{method-BackendRegistry-clear_testing_backends}{}}}
\subsection{Method \code{clear_testing_backends()}}{
Clear all testing-only backends.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRegistry$clear_testing_backends()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
this object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BackendRegistry-get_supported_types"></a>}}
\if{latex}{\out{\hypertarget{method-BackendRegistry-get_supported_types}{}}}
\subsection{Method \code{get_supported_types()}}{
Get a list of all registered backend types.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRegistry$get_supported_types()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector of backend types.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BackendRegistry-get_dependencies"></a>}}
\if{latex}{\out{\hypertarget{method-BackendRegistry-get_dependencies}{}}}
\subsection{Method \code{get_dependencies()}}{
given a tensor type, return the required packages
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRegistry$get_dependencies(tensor_type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tensor_type}}{a string with the tensor type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a character vector with required packages. Length 0 if
no packages are required.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BackendRegistry-is_loadable"></a>}}
\if{latex}{\out{\hypertarget{method-BackendRegistry-is_loadable}{}}}
\subsection{Method \code{is_loadable()}}{
Check if a tensor type is truly loadable,
i.e., if it is registered and has no missing dependencies.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackendRegistry$is_loadable(tensor_type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tensor_type}}{a string with the tensor type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if the tensor type is loadable, FALSE otherwise.
}
}
}
