% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_precinct_analysis.R
\name{split_precinct_analysis}
\alias{split_precinct_analysis}
\title{Split precinct analysis - VAP Adjusted Election Data}
\usage{
split_precinct_analysis(
  vtd,
  planShp,
  block_pop_data,
  vote_col_names = NULL,
  lower_thresh = 0.02,
  upper_thresh = 0.98,
  keepOrigElection = TRUE,
  generatePlots = FALSE,
  ggmap_object = NULL,
  verbose = FALSE
)
}
\arguments{
\item{vtd}{A sf dataframe with precinct-level geometries potentially in the 
district from \code{planShp}. For election adjustments, it should also 
contain election results in columns defined in \code{vote_col_names}.}

\item{planShp}{A sf dataframe with one row containing district plan shape
boundary (one district).}

\item{block_pop_data}{A sf object of blocks covering the region, with vap 
column}

\item{vote_col_names}{Character vector containing the name of the columns to 
be adjusted based on percent vap. This should include election results 
columns names in \code{vtd}.}

\item{lower_thresh}{A decimal. If the percent area of a precinct
inside the \code{planShp} is equal to or below this threshold, the precinct
will be removed. Defaults to .02.}

\item{upper_thresh}{A decimal. If the percent area of a precinct
inside the \code{planShp} is equal to or above this threshold, the precinct
will be considered to be fully contained in the district. Defaults to .98.}

\item{keepOrigElection}{A boolean indicating if original election vote counts
should be preserved in the output dataset for comparison purposes.}

\item{generatePlots}{Boolean indicating if function should generate
a list of map checking plots. If TRUE, the function output will include a list 
of plots that show split precincts and intersecting blocks within and outside 
of the district.}

\item{ggmap_object}{A ggmap object of the area on interest to be the background
of plots if \code{generatePlots = TRUE}. If this argument is not specified, 
plots will be generated without a map background.}

\item{verbose}{A boolean indicating whether to print out status messages.}
}
\value{
If \code{generatePlots = FALSE}, returns a split precinct results
data.frame with vap percentages and adjusted election data. If 
\code{generatePlots = TRUE}, returns a list with the result data.frame in the 
first element and the list of plots in the second.
}
\description{
Run Split Precinct Analysis using precinct-level geometries and 
election data, a district shape, and block-level vap data. This function 
calculates the percent vap of a precinct contained in the district boundary
of interest. Then, if specified, multiplies election vote counts by percent
vap.
}
\examples{
\donttest{
library(eiExpand)
library(sf)

# load data and shps
data(planShp); data(vtd); data(mt_block_data)

# filter to a few vtds for this example
vtd <- vtd \%>\% 
  dplyr::filter(
    GEOID20 \%in\% c("30091000002", "30085000012", "30085000018", "30085000010")
  )

# run split precinct analysis without plots
spa_results <- split_precinct_analysis(
  vtd = vtd, 
  planShp = planShp, 
  block_pop_data = mt_block_data,
  vote_col_names = c('G16HALRZIN', 'G16HALDJUN', 'G16HALLBRE', 
                     'G16GOVRGIA', 'G16GOVDBUL', "G16GOVLDUN"),
  keepOrigElection = TRUE,
  generatePlots = FALSE) 

# run with plots
spa_list <- split_precinct_analysis(
  vtd = vtd, 
  planShp = planShp, 
  block_pop_data = mt_block_data,
  vote_col_names = c('G16HALRZIN', 'G16HALDJUN', 'G16HALLBRE', 
                     'G16GOVRGIA', 'G16GOVDBUL', "G16GOVLDUN"),
  lower_thresh = 0,
  keepOrigElection = TRUE,
  generatePlots = TRUE) 

# View results
spa_list[["results"]]

# View plots
#library(gridExtra)
#do.call("grid.arrange", c(spa_list[["plots"]], ncol=1))
}
}
\author{
Rachel Carroll <rachelcarroll4@gmail.com>

Loren Collingwood <lcollingwood@unm.edu>
}
