% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.R
\name{generate_indices}
\alias{generate_indices}
\title{Create a dataset with indices from a functional dataset in one or multiple
dimensions}
\usage{
generate_indices(
  curves,
  k,
  bs = "cr",
  indices = c("EI", "HI", "MEI", "MHI"),
  n_cores = 1,
  ...
)
}
\arguments{
\item{curves}{\code{matrix} with dimension \eqn{n \times p} in the case of a
one-dimensional functional dataset, or \code{array} of dimension
\eqn{n \times p \times q} in the case of a multivariate functional dataset.
\eqn{n} represents the number of curves, \eqn{p} the number of values along
the curve, and in the second case, \eqn{q} is the number of dimensions.}

\item{k}{Number of basis functions for the B-splines. If equals to 0, the number
of basis functions will be automatically selected.}

\item{bs}{A two letter character string indicating the (penalized) smoothing
basis to use. See \code{\link[mgcv]{smooth.terms}}.}

\item{indices}{Set of indices to be applied to the dataset. They should be
any between EI, HI, MEI and MHI.}

\item{n_cores}{Number of cores to do parallel computation. 1 by default,
which mean no parallel execution. Must be an integer number greater than 1.}

\item{...}{Additional arguments for tfb. See \code{\link[tf]{tfb}}.}
}
\value{
A dataframe containing the indices provided in \code{indices} for
original data, first and second derivatives
}
\description{
Create a dataset with indices from a functional dataset in one or multiple
dimensions
}
\examples{
# 3-dimensional array
x1 <- array(c(1, 2, 3, 3, 2, 1, 5, 2, 3, 9, 8, 7, -1, -5, -6, 2, 3, 0, -1, 0, 2, -1, -2, 0),
  dim = c(3, 4, 2)
)
generate_indices(x1, k = 4)

# matrix
x2 <- matrix(c(1, 2, 3, 3, 2, 1, 5, 2, 3, 9, 8, 7), nrow = 3, ncol = 4)
generate_indices(x2, k = 4)

# using additional parameter for tf::tfb
curves <- sim_model_ex1(n = 10)
generate_indices(
  curves = curves,
  k = 20,
  bs = "bs",
  m = c(3,2),        # additional parameter for tfb
  penalized = FALSE  # additional parameter for tfb
)

}
