% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_jobs.R
\name{edible_jobs}
\alias{edible_jobs}
\title{The jobs created by urban agriculture in your city}
\usage{
edible_jobs(
  x,
  jobs = c(0.000163, 0.022),
  edible = NULL,
  area_col = "edible_area",
  interval = 0.95,
  verbose = FALSE
)
}
\arguments{
\item{x}{An 'sf' object with the urban model of your city and a 'land_use' column with categories of urban features.}

\item{jobs}{A vector of length 2 with the range of jobs created by square meter of edible gardens.}

\item{edible}{The categories in 'land_uses' that represent commercial edible gardens. If NULL, the
land_uses from 'city_land_uses' dataset are used where jobs is TRUE.}

\item{area_col}{The column to be used as the area of each feature. If NULL, the area is calculated with
sf::st_area()}

\item{interval}{A numeric value with the confidence interval returned by the function.}

\item{verbose}{If TRUE, the indicators returns a vector (N=1000) with all simulated values.}
}
\value{
If verbose is FALSE, it returns a named vector with the median and the low and high confidence intervals.
Otherwise, it returns a vector of length 1000 with all simulated values.
}
\description{
This indicator estimates the number of full-time jobs created by commercial urban agriculture
initiatives in your city. It uses a range of jobs per square meter to create the median and the
confidence interval of the number of jobs by simulating a random uniform distribution of 1000 values
within the provided range.
}
\examples{
# First, we set a scenario with commercial gardens that create jobs
scenario <- set_scenario(city_example, pCommercial = 1, quiet = TRUE)
# Get the 95\% confidence interval
edible_jobs(scenario, interval = 0.95)

# Get the raw values from the Monte Carlo simulation and adjust the number of jobs by square meter.
result <- edible_jobs(scenario, jobs = c(0.02, 0.03), verbose = TRUE)
result[1:10]
}
\author{
Josep Pueyo-Ros
}
