% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{glowworms}
\alias{glowworms}
\title{Glowworms Occurrence Data (2014–2024)}
\format{
A tibble with 124 rows and 14 variables:
\describe{
  \item{obs_lat}{Latitude of the observation (decimal degrees)}
  \item{obs_lon}{Longitude of the observation (decimal degrees)}
  \item{date}{Observation date (YYYY-MM-DD)}
  \item{time}{Observation time (HH:MM:SS, character)}
  \item{year}{Observation year}
  \item{month}{Month of the observation}
  \item{day}{Day of the month}
  \item{hour}{Hour of the day (0–23)}
  \item{weekday}{Day of the week (ordered factor)}
  \item{dayofyear}{Day of the year (1–366)}
  \item{sci_name}{Scientific name of the observed species}
  \item{record_type}{Type of observation (e.g., HUMAN_OBSERVATION)}
  \item{obs_state}{Australian state where the observation occurred}
  \item{ws_id}{ID of the nearest weather station (e.g., "949610-99999")}
}
}
\source{
Atlas of Living Australia via \pkg{galah}
}
\usage{
glowworms
}
\description{
This dataset contains cleaned and enriched occurrence records for glowworms
(*Arachnocampa tasmaniensis*) in Australia from 2014 to 2024.
It includes spatial, temporal, taxonomic, and weather station metadata.
}
\details{
Data was sourced via the `galah` package from the Atlas of Living Australia,
filtered and cleaned, then enriched by linking each record to the nearest
weather station using geospatial methods.
}
\examples{
data(glowworms)
head(glowworms)
}
\keyword{datasets}
