#' Nematode taxonomy table
#'
#' Nematode taxonomy table corresponding to the nematode taxonomy ID in the
#' nematode abundance table. The first column of this table corresponds to the
#' first column in nemtab. If calculations related to nematode communities are
#' to be performed, the taxonomy table should be accurate to at least the family
#' and genus level. The variables are as follows:
#' @usage nemtax
#' @format A tibble with 46 rows and 5 variables:
#' \describe{
#'   \item{OTUID}{Taxonomic ID of nematodes.This column corresponds to the first
#'   column of nemtab and cannot have duplicate values.}
#'   \item{Kingdom}{Classification of nematodes at the kingdom level.}
#'   \item{Phylum}{Classification of nematodes at the Phylum level.When reading
#'   in data, this R package will determine whether the table is a nematode
#'   classification table based on whether the Phylum column in the classification
#'   table contains Nematoda. Therefore, if you want to use this package to analyze
#'   the nematode community structure, the Phylum in the classification table must
#'   be Nematoda, otherwise the read-in data will not be automatically associated
#'   with the nematode database.}
#'   \item{Family}{Classification of nematodes at the Family level.}
#'   \item{Genus}{Classification of nematodes at the Genus level.}
#' }
#' @references This dataset referenced from "Li Q-m, Qi X-X, Zhang H-f, Zhang Y-j,
#' Liu H-m, Zhao J-n, Yang D and Wang H (2023) Responses of soil nematode abundance
#' and food web to cover crops in a kiwifruit orchard. Front. Plant Sci. 14:1173157.
#' doi: 10.3389/fpls.2023.1173157"
#' @examples
#' data(nemtax)
#' head(nemtax)
"nemtax"
