% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edl_download.R
\name{edl_download}
\alias{edl_download}
\title{download assets from earthdata over https using bearer tokens}
\usage{
edl_download(
  href,
  dest = basename(href),
  auth = "netrc",
  method = "httr",
  username = default("user"),
  password = default("password"),
  netrc_path = edl_netrc_path(),
  cookie_path = edl_cookie_path(),
  quiet = TRUE,
  ...
)
}
\arguments{
\item{href}{the https URL of the asset}

\item{dest}{local destination}

\item{auth}{the authentication method ("token" for Bearer tokens
or "netrc" for netrc.)}

\item{method}{The download method, either "httr" or "curl".}

\item{username}{EarthData Login User}

\item{password}{EarthData Login Password}

\item{netrc_path}{Path to the .netrc file to be created. Defaults to the
appropriate R package configuration location given by \code{\link[tools:userdir]{tools::R_user_dir()}}.}

\item{cookie_path}{Path to the file where cookies will be stored.  Defaults
to the appropriate R package configuration location given by
\code{\link[tools:userdir]{tools::R_user_dir()}}.}

\item{quiet}{logical default TRUE. Show progress in download?}

\item{...}{additional arguments to \code{download.file()}, e.g. quiet = TRUE.}
}
\value{
the \code{dest} path, invisibly
}
\description{
NOTE: This should be used primarily as a fallback mechanism!
EarthData Cloud resources are often best accessed directly over
HTTPS without download.  This allows subsets to be extracted instead
of downloading unnecessary bits.  Unfortunately, certain formats do
not support such HTTP-based range requests (e.g. HDF4), and require
the asset is downloaded to a local POSIX filesystem first.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
href <- lpdacc_example_url()
edl_download(href)
\dontshow{\}) # examplesIf}
}
