% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_utils.R
\name{ldply_base}
\alias{ldply_base}
\title{ldply_base}
\usage{
ldply_base(.data, .fun = identity, .progress = "none", .id = NA, ...)
}
\arguments{
\item{.data}{A list or vector.}

\item{.fun}{Function to apply to each item.}

\item{.progress}{Show progress bar if 'text'.}

\item{.id}{Name of the index column (used if .data is a named list). Pass NULL to avoid creation of the index column. For compatibility, omit this argument or pass NA to avoid converting the index column to a factor; in this case, ".id" is used as colum name.}

\item{...}{Arguments to .fun.}
}
\description{
A base R implementation of plyr::ldply
}
\examples{
x <- list(a = data.frame(x = 1:2, y = 5:6), b = data.frame(x = 3:4, y = 7:8))
ldply_base(x)
ldply_base(x, .id = NULL)
ldply_base(unname(x))
ldply_base(x, .id = "test")
# compare against standard plyr::ldply
#plyr::ldply(x, .id="test")
str(ldply_base(x))
#str(plyr::ldply(x))
x <- c("01.01.2025","02.01.2025")
ldply_base(x, as.Date.character, tryFormats = "\%d.\%m.\%Y")
#plyr::ldply(x, as.Date.character, tryFormats = "\%d.\%m.\%Y")
}
