#' Small taper dataset from Brink and von Gadow (1986).
#'
#' Taper measurements on 10 \emph{Eucalyptus cloeziana} trees.
#'
#' @docType data
#'
#' @format A data frame with 108 rows and 5 variables:
#' \describe{
#'   \item{Tree}{tree identification number (factor)}
#'   \item{h}{height level, meters}
#'   \item{dib}{diameter inside bark, centimeters}
#'   \item{Dob}{dbh outside bark, cm (breast height is 1.35 m)}
#'   \item{H}{total height, meters}
#' }
#' @source {Brink, C. and von Gadow, K. (1986) "On the use of growth and decay
#'   functions for modelling stem profiles". \emph{EDV in Medizin und Biologi
#'   17}, 20-27}
"brink"
